/************************************************************************/
/*                                                                      */
/* Borland Enterprise Core Objects                                      */
/*                                                                      */
/* Copyright (c) 2003-2005 Borland Software Corporation                 */
/*                                                                      */
/************************************************************************/

using System;
using System.Collections;
using System.Text;
using System.Drawing;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Borland.Eco.UmlRt;
using Borland.Eco.ObjectRepresentation;
using Borland.Eco.Services;
using Borland.Eco.Handles;

namespace Borland.Eco.Web
{
	/// <summary>
	/// Summary description for MethodButtonBinding.
	/// </summary>
	public class MethodButtonBinding
	{
		private readonly IMethod m_Method;
		private readonly OclVariables m_Variables;
		private readonly ElementHandle m_Handle;
		private readonly Button m_Button;
		private readonly EcoSpace m_EcoSpace;

		public  MethodButtonBinding(ElementHandle handle,
			IMethod method,
			OclVariables variables,
			Button button,
			EcoSpace ecoSpace)
		{
			m_Handle = handle;
			m_Method = method;
			m_Variables = variables;
			m_Button = button;
			m_EcoSpace = ecoSpace;
		}

		public void SetButtonEnabledState()
		{
			m_Button.Enabled = MethodCallBuilder.IsMethodEnabled(
				m_Handle,
				m_Method,
				m_Variables,
				m_EcoSpace);
		}


	}
}
